// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/image_downloader/image_downloader.mojom
//

package org.chromium.mojom.image_downloader;

public final class DownloadRequest extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String url;
    public boolean isFavicon;
    public int maxBitmapSize;
    public boolean bypassCache;

    private DownloadRequest(int version) {
        super(STRUCT_SIZE, version);
    }

    public DownloadRequest() {
        this(0);
    }

    public static DownloadRequest deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static DownloadRequest decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        DownloadRequest result = new DownloadRequest(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.url = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isFavicon = decoder0.readBoolean(16, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.bypassCache = decoder0.readBoolean(16, 1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.maxBitmapSize = decoder0.readInt(20);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(url, 8, false);
        encoder0.encode(isFavicon, 16, 0);
        encoder0.encode(bypassCache, 16, 1);
        encoder0.encode(maxBitmapSize, 20);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        DownloadRequest other = (DownloadRequest) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
            return false;
        if (this.isFavicon != other.isFavicon)
            return false;
        if (this.maxBitmapSize != other.maxBitmapSize)
            return false;
        if (this.bypassCache != other.bypassCache)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(isFavicon);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(maxBitmapSize);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(bypassCache);
        return result;
    }
}

